<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="row justify-content-center">
            <div class="col-xl-6">
                <!-- card -->
                <div class="card card-h-100">
                    <!-- card body -->
                    <div class="card-body">
                        <div class="d-flex flex-wrap align-items-center mb-4">
                            <h5 class="card-title me-2">Detail Draft Surat</h5>
                            <div class="ms-auto">
                                <a href="<?php echo e(route('verifikator.download-preview', $surat->id)); ?>"
                                    class="btn btn-primary btn-sm">Unduh
                                    Draft Surat</a>
                                <a href="<?php echo e(route('verifikator.show-surat', $surat->id)); ?>"
                                    class="btn btn-secondary btn-sm">Tampilkan
                                    Surat</a>
                            </div>
                        </div>

                        <div class="row align-items-center">
                            <div class="col-sm text-center">
                                <img src="<?php echo e(asset('assets/images/icon/word.png')); ?>">
                            </div>
                            <div class="col-sm align-self-center">
                                <div class="mt-4 mt-sm-0">
                                    <p class="mb-1 fw-bold">Nomor Dokumen</p>
                                    <h4><?php echo e($surat->NomorSurat); ?></h4>
                                    <div class="row g-0">
                                        <div class="col-6">
                                            <div>
                                                <p class="mb-2 text-muted text-uppercase font-size-11">Drafter</p>
                                                <h5 class="fw-medium"><?php echo e($surat->getPenulis->name); ?></h5>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div>
                                                <p class="mb-2 text-muted text-uppercase font-size-11">Penerima Surat</p>
                                                <h5 class="fw-medium"><?php echo e($surat->getPenerima->name); ?></h5>
                                            </div>
                                        </div>
                                    </div>

                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        Update Status dan Catatan Revisi
                    </div>
                    <div class="card-body">

                        <form method="POST" action="<?php echo e(route('verifikator.store')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mb-3">
                                <label for="status">Status</label>
                                <select name="Status" class="form-control" required>
                                    <option value="" disabled selected>Pilih Status</option>
                                    <option value="Verified" <?php echo e($surat->Status == 'Verified' ? 'selected' : ''); ?>>
                                        Verified
                                    </option>
                                    <option value="Revision" <?php echo e($surat->Status == 'Revision' ? 'selected' : ''); ?>>
                                        Revision
                                    </option>
                                </select>
                            </div>


                            <div class="form-group mb-3">
                                <label for="revisi">Catatan Revisi</label>
                                <textarea name="Catatan" class="form-control" id="ckeditor-classic" name="Isi" rows="10"><?php echo e(old('revisi', $surat->getCatatan->Catatan ?? '')); ?></textarea>
                            </div>
                            <input type="hidden" name="idsurat" value="<?php echo e(old('idsurat', $surat->id)); ?>">

                            <button type="submit" class="btn btn-primary w-100">Update Status</button>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\SuratNew\resources\views/verifikator/show.blade.php ENDPATH**/ ?>